<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Follow;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagFollowTable;

final class HashtagFollowFinder extends AbstractFinder implements InterfaceHashtagFollowSetter
{
    /**
     * setter interface
     */
    use TraitHashtagFollowSetters;

    public function getTableName(): string
    {
        return HashtagFollowTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {HashtagFollowTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): HashtagFollowModel
    {
        return HashtagFollowModel::createFromUntouchedBean_noException(parent::pop());
    }
}
